#ifndef APP_DATA_H
#define APP_DATA_H

C_APPLICATION	Game;				// obiekt gry
float			GameSpeed = 0;		// predkosc gry
float			TimeSpeed = 0;
int				Moves = 0;			// moliwe ruchy
int				Room = 1;			// aktualna scena
int				Map = 1;			// aktualnie odpalona mapa
XE_STRING		DSave = "";			// directory
XE_CONTAINER< C_ELM_SOUND > Sounds; // kontener nazw dwikw



/* CB1 */
class CB1 : public XE_ACTOR2D // klasa bbelka
{
public:
	CB1( XE_VECTOR pos=0);
	~CB1(); // To odpowiada za niszczenie si danej klasy
	void Render(); // A to za jej rysowanie
};

/* CB2 */
class CB2 : public XE_ACTOR2D // klasa bbelka 2
{
public:
	CB2( XE_VECTOR pos=0);
	~CB2();
	void Render();
};

/* CB3 */
class CB3 : public XE_ACTOR2D // klasa bbelka 3
{
public:
	CB3( XE_VECTOR pos=0);
	~CB3();
	void Render();
};

/* Brick */
class Brick : public XE_ACTOR2D // klasa "murku"
{
public:
	Brick( XE_VECTOR pos=0);
	~Brick();
	void Render();
};

/* PUp */
class PUp : public XE_ACTOR2D // klasa bonusu ( 1 ruch wicej )
{
public:
	PUp( XE_VECTOR pos=0);
	~PUp();
	void Render();
};

/* CSB1 */
class CSB1 : public XE_ACTOR2D // klasa bbelka maego
{
public:
	int Direction;
	CSB1( XE_VECTOR pos=0, int direction = 1);
	~CSB1();
	void Render();
	void Update();
};

/* CEditor */
class CEditor
{
public:
	enum ENUM
	{
		BUILD_BEGIN,
		BCB1,
		BCB2,
		BCB3,
		BBrick,
		BPUp,
		BUILD_END
	};
	int Build;		// typ budowanych obiektow
	CEditor();
	void Update();
	void Render();
	bool Save( char* fname );
	bool Load( char* fname );
	void Clear();
}Editor;



/* CB1 */
CB1::CB1( XE_VECTOR pos )
{
	Game.Describe( this, "CB1" );
	Sprite = Game.Sprites.Access( "GB1" );
	Position = pos;
}

CB1::~CB1()
{
	Sprite = XE_SPRITE();
	if( Room == 1 ) {  // Jesli jestesmy w trakcie gry ( nie w edytorze )
		for(int i = 1;i < 5;i += 1) { // Tworzymy mini bbelki
			Game.RegisterActor( "CSB1", new CSB1( XE_VECTOR(Position.X,Position.Y), i ) );
		}
	}
}

void CB1::Render()
{
	DrawSprite();
}

/* CB2 */
CB2::CB2( XE_VECTOR pos )
{
	Game.Describe( this, "CB2" );
	Sprite = Game.Sprites.Access( "GB2" );
	Position = pos;
}

CB2::~CB2()
{
	Sprite = XE_SPRITE();
	if( Room == 1 ) { // Jesli jestesmy w trakcie gry ( nie w edytorze )
		Game.RegisterActor( "CB1", new CB1( XE_VECTOR(Position.X,Position.Y)) ); // Tworzymy bbelek innego typu
	}
}

void CB2::Render()
{
	DrawSprite();
}

/* CB3 */
CB3::CB3( XE_VECTOR pos )
{
	Game.Describe( this, "CB3" );
	Sprite = Game.Sprites.Access( "GB3" );
	Position = pos;
}

CB3::~CB3()
{
	Sprite = XE_SPRITE();
	if( Room == 1 ) { // Jesli jestesmy w trakcie gry ( nie w edytorze )
		Game.RegisterActor( "CB2", new CB2( XE_VECTOR(Position.X,Position.Y)) ); // Tworzymy bbelek innego typu
	}
}

void CB3::Render()
{
	DrawSprite();
}

/* Brick */
Brick::Brick( XE_VECTOR pos )
{
	Game.Describe( this, "Brick" );
	Sprite = Game.Sprites.Access( "Brick" );
	Position = pos;
}

Brick::~Brick()
{
	Sprite = XE_SPRITE();
}

void Brick::Render()
{
	DrawSprite();
}

/* PUp */
PUp::PUp( XE_VECTOR pos )
{
	Game.Describe( this, "PUp" );
	Sprite = Game.Sprites.Access( "PUp" );
	Position = pos;
}

PUp::~PUp()
{
	Sprite = XE_SPRITE();
	if( Room == 1 ) { // Jesli jestesmy w trakcie gry ( nie w edytorze )
		Moves += 1; // Dodajemy ruch wicej
	}
}

void PUp::Render()
{
	DrawSprite();
}

/* CSB1 */
CSB1::CSB1( XE_VECTOR pos, int direction )
{
	Game.Describe( this, "CSB1" );
	Sprite = Game.Sprites.Access( "GSB1" );
	Position = pos;
	Direction = direction;
}

CSB1::~CSB1()
{
	Sprite = XE_SPRITE();
}

void CSB1::Render()
{
	DrawSprite();
}

void CSB1::Update()
{
	switch(Direction) { // poruszanie si bbelka
	case 1:
		Position.X+=100 * GameSpeed;
		break;
	case 2:
		Position.X-=100 * GameSpeed;
		break;
	case 3:
		Position.Y+=100 * GameSpeed;
		break;
	case 4:
		Position.Y-=100 * GameSpeed;
		break;
	}

	// kolizja z duymi bbelkami oraz bonusem
	if( Game.Collision2D( XEF_BOX, this, "CB1" ) || Game.Collision2D( XEF_BOX, this, "CB2" ) || Game.Collision2D( XEF_BOX, this, "CB3" ) || Game.Collision2D( XEF_BOX, this, "PUp" ) ) {
		Game.Audio.SoundPlay( Sounds.Access( "1" ) ); // odtwarzamy dwik
		// sprawdza czy istnieje juz jakis obiekt w danej komorce siatki
		XE_ACTOR* coll = 0;
		XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		{
			if( Game.IsDescribedAs( elm(), "CB1" ) || Game.IsDescribedAs( elm(), "CB2" ) || Game.IsDescribedAs( elm(), "CB3" ) || Game.IsDescribedAs( elm(), "PUp" ) )
				if( RectCollision( Position + XE_VECTOR( 8, 8 ), elm()->Position, elm()->Position + XE_VECTOR( 32, 32 ) ) )
				{
					coll = elm();
					break;
				}
		}
		// niszczenie obiektu jesli istnieje w danej komorce siatki
		if( coll ) {
			Game.UnregisterActor( coll );
			Game.UnregisterActor( this );
		}
	}

	// jeli bbelek bdzie poza ekranem to go niszczy, oraz przy kolizji z murkiem
	if( Position.X > 800 || Position.X < 0 || Position.Y > 600 || Position.Y < 0 || Game.Collision2D( XEF_BOX, this, "Brick") )
		Game.UnregisterActor( this );
}

/* CEditor */
CEditor::CEditor()
{
	Build = BCB1;
}

void CEditor::Update()
{

	// pozycja myszy dopasowana do siatki 32x32
	XE_VECTOR mpos = Game.MouseGetViewPos( "main" );
	mpos.X = floor( mpos.X / 32 ) * 32;
	mpos.Y = floor( mpos.Y / 32 ) * 32;

	if( XE_IO::KeyboardGetPressed( XE_KEY_DASH ) ) // Klikamy -
	{
		if( Moves>1 ) Moves -= 1; // Jeli zosta nam wicej ni jeden ruch to odejmujemy ruch
	}
	if( XE_IO::KeyboardGetPressed( XE_KEY_EQUAL ) ) // Klikamy +
	{
		Moves += 1; // Dodajemy ruch
	}

	// zmiana typu obiektu do budowania
	if( XE_IO::MouseGet( XE_MOUSE_WHEELUP ) || XE_IO::KeyboardGetPressed( XE_KEY_PAGEUP ) )
	{
		Build--;
		if( Build <= BUILD_BEGIN ) Build = BUILD_END - 1;
	}
	else
		if( XE_IO::MouseGet( XE_MOUSE_WHEELDOWN ) || XE_IO::KeyboardGetPressed( XE_KEY_PAGEDOWN ) )
		{
			Build++;
			if( Build >= BUILD_END ) Build = BUILD_BEGIN + 1;
		}

		// stawianie obiektow ( pozycji X oraz Y myszki nie moe by rwna 0 )
		if( XE_IO::MouseGet( XE_MOUSE_LEFT ) && mpos.X != 0 && mpos.Y != 0 )
		{
			// sprawdza czy istnieje juz jakis obiekt w danej komorce siatki
			XE_ACTOR* coll = 0;
			XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
			{
				if( Game.IsDescribedAs( elm(), "CB1" ) ||
					Game.IsDescribedAs( elm(), "CB2" ) ||
					Game.IsDescribedAs( elm(), "CB3" ) ||
					Game.IsDescribedAs( elm(), "Brick" ) || 
					Game.IsDescribedAs( elm(), "PUp" ) )
					if( RectCollision( mpos + XE_VECTOR( 16, 16 ), elm()->Position, elm()->Position + XE_VECTOR( 32, 32 ) ) )
					{
						coll = elm();
						break;
					}
			}
			// stawia dany obiekt jesli komorka siatki jest pusta
			if( !coll )
			{
				if( Build == BCB1 )
					Game.RegisterActor( "CB1", new CB1( mpos ) );
				else if( Build == BCB2 )
					Game.RegisterActor( "CB2", new CB2( mpos ) );
				else if( Build == BCB3 )
					Game.RegisterActor( "CB3", new CB3( mpos ) );
				else if( Build == BBrick )
					Game.RegisterActor( "Brick", new Brick( mpos ) );
				else if( Build == BPUp )
					Game.RegisterActor( "PUp", new PUp( mpos ) );
			}
		}
		// kasowanie obiektu w danej komorce siatki
		if( XE_IO::MouseGet( XE_MOUSE_RIGHT ) )
		{
			// sprawdza czy istnieje juz jakis obiekt w danej komorce siatki
			XE_ACTOR* coll = 0;
			XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
			{
				if( Game.IsDescribedAs( elm(), "CB1" ) ||
					Game.IsDescribedAs( elm(), "CB2" ) ||
					Game.IsDescribedAs( elm(), "CB3" ) ||
					Game.IsDescribedAs( elm(), "Brick" ) || 
					Game.IsDescribedAs( elm(), "PUp" ) )
					if( RectCollision( mpos + XE_VECTOR( 16, 16 ), elm()->Position, elm()->Position + XE_VECTOR( 32, 32 ) ) )
					{
						coll = elm();
						break;
					}
			}
			// niszczenie obiektu jesli istnieje w danej komorce siatki
			if( coll )
				Game.UnregisterActor( coll );
		}
}

void CEditor::Render()
{
	XE_VECTOR mpos = Game.MouseGetViewPos( "main" );
	mpos.X = floor( mpos.X / 32 ) * 32;
	mpos.Y = floor( mpos.Y / 32 ) * 32;

	// rysowanie aktywnego typu obiektu do budowania
	if( Build == BCB1 )
		Game.Sprites( "GB1" )->Draw( XE_VECTOR( mpos.X, mpos.Y ) );
	else
		if( Build == BCB2 )
			Game.Sprites( "GB2" )->Draw( XE_VECTOR( mpos.X, mpos.Y ) );
		else
			if( Build == BCB3 )
				Game.Sprites( "GB3" )->Draw( XE_VECTOR( mpos.X, mpos.Y ) );
			else
				if( Build == BBrick )
					Game.Sprites( "Brick" )->Draw( XE_VECTOR( mpos.X, mpos.Y ) );
				else
					if( Build == BPUp )
						Game.Sprites( "PUp" )->Draw( XE_VECTOR( mpos.X, mpos.Y ) );
}

bool CEditor::Save( char* fname )
{
	// zapis obiektow do pliku
	XE_FILE f;
	f.Write( &Moves, sizeof( int ) );
	unsigned int count = Game.Actors.Count( "CB1" );
	f.Write( &count, sizeof( unsigned int ) );
	XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		if( Game.IsDescribedAs( elm(), "CB1" ) )
			f.Write( &elm()->Position, sizeof( XE_VECTOR ) );
	count = Game.Actors.Count( "CB2" );
	f.Write( &count, sizeof( unsigned int ) );
	XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		if( Game.IsDescribedAs( elm(), "CB2" ) )
			f.Write( &elm()->Position, sizeof( XE_VECTOR ) );
	count = Game.Actors.Count( "CB3" );
	f.Write( &count, sizeof( unsigned int ) );
	XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		if( Game.IsDescribedAs( elm(), "CB3" ) )
			f.Write( &elm()->Position, sizeof( XE_VECTOR ) );
	count = Game.Actors.Count( "Brick" );
	f.Write( &count, sizeof( unsigned int ) );
	XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		if( Game.IsDescribedAs( elm(), "Brick" ) )
			f.Write( &elm()->Position, sizeof( XE_VECTOR ) );
	count = Game.Actors.Count( "PUp" );
	f.Write( &count, sizeof( unsigned int ) );
	XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		if( Game.IsDescribedAs( elm(), "PUp" ) )
			f.Write( &elm()->Position, sizeof( XE_VECTOR ) );
	f.Save( fname );
	f.Free();
	Game.Message("Ok.","Blast Me!"); // pokazujemy komunikat o zapisaniu mapy
	return( true );
}

bool CEditor::Load( char* fname )
{
	// odczyt i generowanie obiektow z pliku
	XE_FILE f;
	f.Load(fname);
	if( !f.Size(fname) ) { // jeli nie ma pliku z mapk
		if( Room == 1 ) { // Jesli jestesmy w trakcie gry ( nie w edytorze )
			if ( Map == 1 ) { // jeli gra ma wczyta pierwsz mape
				Game.Message("Brak pierwszej mapy, lub nie wybrae folderu!","Blast Me!"); // pokazujemy stosowny komunikat
			}
			else { // jeli jednak wczytujemy inne mapki( np. mapa nr 2, 3, 4 ), a nie ma tych mapek, to najprawdopodobniej gracz skoczy gr
				Game.Message("BRAWO! SKOCZYE WANIE PACZKE MAP!","Blast Me!"); // pokazujemy stosowny komunikat
				Map = 1; // znowu bdziemy wczytywa pierwsz mape
			}
			Moves = -10; // zmienia liczb ruchw na -10 aby gra wiedziaa, e nie mona zaadowa mapki
		} else { // jeli nie jestemy w w trakcie gry
			Game.Message("Brak mapy!","Blast Me!"); // pokazujemy komunikat
		}
	} 
	else {
		Clear();
		f.Read( &Moves, sizeof( int ) );
		XE_VECTOR pos;
		unsigned int count = 0;
		f.Read( &count, sizeof( unsigned int ) );
		repeat( count )
		{
			f.Read( &pos, sizeof( XE_VECTOR ) );
			Game.RegisterActor( "CB1", new CB1( pos ) );
		}
		count = 0;
		f.Read( &count, sizeof( unsigned int ) );
		repeat( count )
		{
			f.Read( &pos, sizeof( XE_VECTOR ) );
			Game.RegisterActor( "CB2", new CB2( pos ) );
		}
		count = 0;
		f.Read( &count, sizeof( unsigned int ) );
		repeat( count )
		{
			f.Read( &pos, sizeof( XE_VECTOR ) );
			Game.RegisterActor( "CB3", new CB3( pos ) );
		}
		count = 0;
		f.Read( &count, sizeof( unsigned int ) );
		repeat( count )
		{
			f.Read( &pos, sizeof( XE_VECTOR ) );
			Game.RegisterActor( "Brick", new Brick( pos ) );
		}
		count = 0;
		f.Read( &count, sizeof( unsigned int ) );
		repeat( count )
		{
			f.Read( &pos, sizeof( XE_VECTOR ) );
			Game.RegisterActor( "PUp", new PUp( pos ) );
		}
		return( true );
	}
	f.Free();
	return( false );
}

void CEditor::Clear()
{
	// kasowanie wszystkich obiektow
	XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		Game.UnregisterActor( elm() );
}

#endif /* APP_DATA_H */
